/*:
 * @target MZ
 * @plugindesc NameBox × Overlay/Backlog 互換パッチ — 表示中は名前欄を自動で隠す or 低Z化
 * @author HS
 * @help
 * OverlapNameBox=ON で NameBox が前面に固定される問題を、
 * オプションやバックログを開いている間だけ抑止します。
 *
 * 既定: 隠す（非表示）。zIndex 方式に切替も可能です。
 *
 * @param mode
 * @text 動作モード
 * @type select
 * @option hide（推奨）
 * @value hide
 * @option zindex（描画順を下げる）
 * @value zindex
 * @default hide
 */
(() => {
  'use strict';
  const PN = document.currentScript.src.split('/').pop().replace(/\.js$/,'');
  const P  = PluginManager.parameters(PN);
  const MODE = (P.mode || 'hide');

  // === 状態判定 ===
  const isOptionsOpen = () =>
    !!(SceneManager._scene && (SceneManager._scene._hsOptionsWin || (window.HS && HS.isOptionsOverlayOpen && HS.isOptionsOverlayOpen())));

  const isBacklogOpen = () => {
    const sc = SceneManager._scene;
    if (!sc) return false;
    if (window.HSBL && typeof HSBL.isOpen === 'function' && HSBL.isOpen()) return true;
    // フォールバック：Scene内からバックログっぽいウィンドウを拾う
    let found = false;
    const walk = (c) => {
      if (!c || found) return;
      if (c.constructor && /Backlog/i.test(c.constructor.name) && c.visible) found = true;
      if (c.children) c.children.forEach(walk);
    };
    walk(sc);
    return found;
  };

  const findNameBox = (scene) => {
    if (!scene) return null;
    // 標準参照
    if (scene._nameBoxWindow) return scene._nameBoxWindow;
    // 再配置されている場合に備えて全探索
    let nb = null;
    const walk = (c) => {
      if (nb || !c) return;
      if (c instanceof Window_NameBox) { nb = c; return; }
      if (c.children) c.children.forEach(walk);
    };
    walk(scene);
    return nb;
  };

  const bringFront = (obj, z=999999) => {
    const sc = SceneManager._scene;
    if (!sc || !obj || !obj.parent) return;
    // zIndexで前面に（親をsortableに）
    obj.parent.sortableChildren = true;
    obj.zIndex = z;
    obj.parent.sortChildren?.();
  };

  // === 毎フレーム監視して制御 ===
  const _SceneBase_update = Scene_Base.prototype.update;
  Scene_Base.prototype.update = function() {
    _SceneBase_update.apply(this, arguments);
    const sc = SceneManager._scene;
    const nb = findNameBox(sc);
    const overlayOn = isOptionsOpen() || isBacklogOpen();

    if (nb) {
      if (MODE === 'hide') {
        nb.visible = !overlayOn;
      } else {
        // zIndex 方式：NameBoxを背面へ/オーバーレイを前面へ
        if (overlayOn) {
          try {
            // オプションウィンドウやバックログを前面に
            const cand = sc._hsOptionsWin || sc._hsBacklogWin || null;
            if (cand) bringFront(cand, 1e7);
            bringFront(nb, 10); // NameBoxを相対的に低く
          } catch(_) {}
        }
        nb.visible = true; // zIndex方式では可視のまま
      }
    }
  };
})();
